/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.fedc;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class LogCollectionAgent {
    private static final String TRACE_MASKT = "XPALFEDT";
    private static final String TRACE_MASKF = "XPALFEDF";
    private static final String TRACE_MASKD = "XPALFEDD";
    private static final String VR_DIRECTORY = "virtualretain";

    public static String[] getFileList(Log log) throws HException {
        String[] sArray;
        block16: {
            Trace.trace(TRACE_MASKT, "--> getFileList()");
            sArray = null;
            ArrayList<String> rawList = new ArrayList<String>();
            ArrayList<String> resolvedList = new ArrayList<String>();
            if (log != null) {
                if (log.getLogClass() == 11 && log.getLogType() == 20) {
                    Trace.trace(TRACE_MASKD, "got a PA Results file");
                    LogBlock secondaryBlock = log.getLogBlock((byte)4);
                    if (secondaryBlock != null) {
                        byte[] rawLog = (byte[])secondaryBlock.getData();
                        String primaryString = new String(rawLog);
                        primaryString = primaryString.toLowerCase();
                        Trace.trace(TRACE_MASKD, "the primary string is " + primaryString);
                        int location = 0;
                        String startUuid = "<uuid>";
                        String endUuid = "</uuid>";
                        location = primaryString.indexOf(startUuid);
                        if (location != -1) {
                            Trace.trace(TRACE_MASKD, "found it at " + location);
                            String uuid = primaryString.substring(startUuid.length(), primaryString.indexOf(endUuid));
                            Trace.trace(TRACE_MASKF, "looking up problem " + uuid);
                            try {
                                Problem aProblem = ProblemManager.getProblemManager().getProblem(uuid);
                                if (aProblem instanceof CommonProblem) {
                                    Trace.trace(TRACE_MASKD, "got a common problem");
                                    String eedLocation = ((CommonProblem)aProblem).getEEDLocation();
                                    if (eedLocation != null) {
                                        Trace.trace(TRACE_MASKD, "the eed location is " + eedLocation);
                                        sArray = new String[]{eedLocation};
                                    }
                                    break block16;
                                }
                                Trace.trace(TRACE_MASKD, "got a non common problem");
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKD, "got an exception.  Just tracing for debug.");
                                Trace.trace(TRACE_MASKD, "this is for information only.");
                                Trace.trace(TRACE_MASKD, e);
                            }
                        } else {
                            Trace.trace(TRACE_MASKD, "didn't find it");
                        }
                    }
                } else {
                    Trace.trace(TRACE_MASKD, "got a different type of log");
                    LogBlock dfBlock = log.getLogBlock((byte)-33);
                    if (dfBlock != null) {
                        Trace.trace(TRACE_MASKD, "we got a df block");
                        String theData = new String((byte[])dfBlock.getData()).trim();
                        Trace.trace(TRACE_MASKD, "the df data is " + theData);
                        StringTokenizer st = new StringTokenizer(theData, ",");
                        while (st.hasMoreTokens()) {
                            String fileName = st.nextToken().trim();
                            Trace.trace(TRACE_MASKD, "the file name is" + fileName);
                            rawList.add(fileName);
                        }
                    }
                    Iterator it = rawList.iterator();
                    while (it.hasNext()) {
                        String name = (String)it.next();
                        Trace.trace(TRACE_MASKD, "resolving " + name);
                        String resolvedPath = BaseFileControl.getFilePath(name);
                        Trace.trace(TRACE_MASKD, "the path is " + resolvedPath);
                        resolvedList.add(resolvedPath + name);
                    }
                    sArray = resolvedList.toArray(new String[0]);
                }
            } else {
                Trace.trace(TRACE_MASKF, "the log was null");
                Trace.trace(TRACE_MASKT, "<-- getFileList(null)");
            }
        }
        Trace.trace(TRACE_MASKD, "the return data is");
        if (sArray != null) {
            for (int i = 0; i < sArray.length; ++i) {
                Trace.trace(TRACE_MASKD, "element [" + i + "] is " + sArray[i]);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- LogCollectionAgent()");
        return sArray;
    }

    public static void main(String[] args) {
        try {
            String primaryString = "<uuid>22a34be2-7e94-11d9-8109-00096bf2cae1</uuid>";
            int location = 0;
            String startUuid = "<uuid>";
            String endUuid = "</uuid>";
            location = primaryString.indexOf(startUuid);
            if (location != -1) {
                Trace.trace(TRACE_MASKD, "found it at " + location);
                String uuid = primaryString.substring(startUuid.length(), primaryString.indexOf(endUuid));
                Trace.trace(TRACE_MASKF, "looking up problem " + uuid);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }
}

